<?php
session_start();
define( 'CLIENTCONTROLLERABSPATH3', dirname(dirname(dirname(__FILE__))) . '/' );

class CommonController {
    public $funconn;
    public $adminfunconn;

    public function __construct () {
      if(file_exists(CLIENTCONTROLLERABSPATH3."includes/functions.php"))
      {
      include_once(CLIENTCONTROLLERABSPATH3."includes/functions.php");
      $this->funconn = new clientcontrolfunctions();
      } 
      if(file_exists(CLIENTCONTROLLERABSPATH3."admin/includes/functions.php"))
      {
      include_once(CLIENTCONTROLLERABSPATH3."admin/includes/functions.php");
      $this->adminfunconn = new controlfunctions();
      }  
    } 

    public function updatelocalkey($NewLocalKey, $conn = '') {
      $returnData = array();  
      if(!empty($conn))
      {
          $QueryData = array("request"=> "Update","table"=> "webtvtheme_settings", "data" => array("settings" => "localKey"),"updatedata" => array("value" => $NewLocalKey)); 
           $ExecuteQuery =  $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
           if($ExecuteQuery["result"] == "success")
           {
              $returnData = $ExecuteQuery;
           }
      }
      return $returnData;
    }

    
    public function getconfigurationoption($conn = '',$format = "") {
      $returnData = array();
      if(!empty($conn))
      {
        $QueryData = array("request"=> "Get","table"=> "webtvtheme_settings", "data" => array()); 
        $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn); //Call Function to exicute query
        if($format == "")
        {
          $returnData = $ExecuteQuery;
        }
        else
        {
          if(!empty($ExecuteQuery))
          {
             foreach($ExecuteQuery as $ConfigFetch)
            {
                $returnData[$ConfigFetch["settings"]] = $ConfigFetch["value"];
            } 
          }
        }        
      }
      return $returnData;
    }

    public function checkportalvalid($portallink = '') {
      $returnData = array();
      if(!empty($portallink))
      { 
         $ApiLinkIs = $portallink;
         $http = curl_init($ApiLinkIs);
         curl_setopt($http, CURLOPT_SSL_VERIFYPEER, 0);
         curl_setopt($http, CURLOPT_SSL_VERIFYHOST, 0);
         // do your curl thing here
         $result = curl_exec($http);

         $http_status = curl_getinfo($http, CURLINFO_HTTP_CODE);
         
         curl_close($http);

        $returnData = $http_status;
      }
      return $returnData;
    }

    public function CallApiRequest($ApiLinkIs = '') {
      $returnData = '0';
      $UserAgent = (isset($_SERVER['HTTP_USER_AGENT']) && $_SERVER['HTTP_USER_AGENT'] != "")?$_SERVER['HTTP_USER_AGENT']:"Mozilla/5.0 (Windows NT 5.1; rv:31.0) Gecko/20100101 Firefox/31.0";
      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $ApiLinkIs);
      curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
      curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	$headers = array();
	$headers[] = 'User-Agent: '.$UserAgent;
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
      if(curl_exec($ch) === FALSE) 
      {
         return array('result' => 'error', 'data' => 'Invalid Host Url');
      } 
      $Result =  json_decode(curl_exec($ch)); 
      if(!empty($Result))
      {
        $returnData = $Result;
          return array('result' => 'success', 'data' => $returnData);
      }
      else
      {
          return array('result' => 'error');
      }
    }



    public function checklicense($licensekey, $localkey = '') {
      $whmcsurl = "https://www.whmcssmarters.com/clients/";
      $licensing_secret_key = "webpanel8333";
      $localkeydays = 14;
      $allowcheckfaildays = 5;
      $check_token = time() . md5(mt_rand(1000000000, 9999999999) . $licensekey);
      $checkdate = date("Ymdhis");
      $domain = $_SERVER['SERVER_NAME'];
      $usersip = isset($_SERVER['SERVER_ADDR']) ? $_SERVER['SERVER_ADDR'] : $_SERVER['LOCAL_ADDR'];
      $dirpath = dirname(__FILE__);
      $verifyfilepath = 'modules/servers/licensing/verify.php';
      $localkeyvalid = false;
      if ($localkey) {
          $localkey = str_replace("\n", '', $localkey); # Remove the line breaks
          $localdata = substr($localkey, 0, strlen($localkey) - 32); # Extract License Data
          $md5hash = substr($localkey, strlen($localkey) - 32); # Extract MD5 Hash
          if ($md5hash == md5($localdata . $licensing_secret_key)) {
              $localdata = strrev($localdata); # Reverse the string
              $md5hash = substr($localdata, 0, 32); # Extract MD5 Hash
              $localdata = substr($localdata, 32); # Extract License Data
              $localdata = base64_decode($localdata);
              $localkeyresults = unserialize($localdata);
              $originalcheckdate = $localkeyresults['checkdate'];
              if ($md5hash == md5($originalcheckdate . $licensing_secret_key)) {
                  $localexpiry = date("Ymdhis", mktime(date("h"), date("i"), date("s"), date("m"), date("d") - $localkeydays, date("Y")));
                  if ($originalcheckdate > $localexpiry) {
                      $localkeyvalid = true;
                      $results = $localkeyresults;
                      $validdomains = explode(',', $results['validdomain']);
                      if (!in_array($_SERVER['SERVER_NAME'], $validdomains)) {
                          $localkeyvalid = false;
                          $localkeyresults['status'] = "Invalid";
                          $results = array();
                      }
                      $validips = explode(',', $results['validip']);
                      if (!in_array($usersip, $validips)) {
                          $localkeyvalid = false;
                          $localkeyresults['status'] = "Invalid";
                          $results = array();
                      }
                      $validdirs = explode(',', $results['validdirectory']);
                      if (!in_array($dirpath, $validdirs)) {
                          $localkeyvalid = false;
                          $localkeyresults['status'] = "Invalid";
                          $results = array();
                      }
                  }
              }
          }
      }
      if (!$localkeyvalid) {
          $responseCode = 0;
          $postfields = array(
              'licensekey' => $licensekey,
              'domain' => $domain,
              'ip' => $usersip,
              'dir' => $dirpath,
          );
          if ($check_token)
              $postfields['check_token'] = $check_token;
          $query_string = '';
          foreach ($postfields AS $k => $v) {
              $query_string .= $k . '=' . urlencode($v) . '&';
          }
          if (function_exists('curl_exec')) {
              $ch = curl_init();
              curl_setopt($ch, CURLOPT_URL, $whmcsurl . $verifyfilepath);
              curl_setopt($ch, CURLOPT_POST, 1);
              curl_setopt($ch, CURLOPT_POSTFIELDS, $query_string);
              curl_setopt($ch, CURLOPT_TIMEOUT, 30);
              curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
              $data = curl_exec($ch);
              $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
              curl_close($ch);
          } else {
              $responseCodePattern = '/^HTTP\/\d+\.\d+\s+(\d+)/';
              $fp = @fsockopen($whmcsurl, 80, $errno, $errstr, 5);
              if ($fp) {
                  $newlinefeed = "\r\n";
                  $header = "POST " . $whmcsurl . $verifyfilepath . " HTTP/1.0" . $newlinefeed;
                  $header .= "Host: " . $whmcsurl . $newlinefeed;
                  $header .= "Content-type: application/x-www-form-urlencoded" . $newlinefeed;
                  $header .= "Content-length: " . @strlen($query_string) . $newlinefeed;
                  $header .= "Connection: close" . $newlinefeed . $newlinefeed;
                  $header .= $query_string;
                  $data = $line = '';
                  @stream_set_timeout($fp, 20);
                  @fputs($fp, $header);
                  $status = @socket_get_status($fp);
                  while (!@feof($fp) && $status) {
                      $line = @fgets($fp, 1024);
                      $patternMatches = array();
                      if (!$responseCode && preg_match($responseCodePattern, trim($line), $patternMatches)
                      ) {
                          $responseCode = (empty($patternMatches[1])) ? 0 : $patternMatches[1];
                      }
                      $data .= $line;
                      $status = @socket_get_status($fp);
                  }
                  @fclose($fp);
              }
          }
          if ($responseCode != 200) {
              $localexpiry = date("Ymdhis", mktime(date("h"), date("i"), date("s"), date("m"), date("d") - ($localkeydays + $allowcheckfaildays), date("Y")));
              if ($originalcheckdate > $localexpiry) {
                  $results = $localkeyresults;
              } else {
                  $results = array();
                  $results['status'] = "Invalid";
                  $results['description'] = "Remote Check Failed";
                  return $results;
              }
          } else {
              preg_match_all('/<(.*?)>([^<]+)<\/\\1>/i', $data, $matches);
              $results = array();
              foreach ($matches[1] AS $k => $v) {
                  $results[$v] = $matches[2][$k];
              }
          }
          if (!is_array($results)) {
              die("Invalid License Server Response");
          }
          if ($results['md5hash']) {
              if ($results['md5hash'] != md5($licensing_secret_key . $check_token)) {
                  $results['status'] = "Invalid";
                  $results['description'] = "MD5 Checksum Verification Failed";
                  return $results;
              }
          }
          if ($results['status'] == "Active") {
              $results['checkdate'] = $checkdate;
              $data_encoded = serialize($results);
              $data_encoded = base64_encode($data_encoded);
              $data_encoded = md5($checkdate . $licensing_secret_key) . $data_encoded;
              $data_encoded = strrev($data_encoded);
              $data_encoded = $data_encoded . md5($data_encoded . $licensing_secret_key);
              $data_encoded = wordwrap($data_encoded, 80, "\n", true);
              $results['localkey'] = $data_encoded;
          }
          $results['remotecheck'] = true;
      }
      unset($postfields, $data, $matches, $whmcsurl, $licensing_secret_key, $checkdate, $usersip, $localkeydays, $allowcheckfaildays, $md5hash);
      return $results;
  }

   public function client_ipaddress() {
     $ipaddress = '';
    if (getenv('HTTP_CLIENT_IP'))
        $ipaddress = getenv('HTTP_CLIENT_IP');
    else if(getenv('HTTP_X_FORWARDED_FOR'))
        $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
    else if(getenv('HTTP_X_FORWARDED'))
        $ipaddress = getenv('HTTP_X_FORWARDED');
    else if(getenv('HTTP_FORWARDED_FOR'))
        $ipaddress = getenv('HTTP_FORWARDED_FOR');
    else if(getenv('HTTP_FORWARDED'))
       $ipaddress = getenv('HTTP_FORWARDED');
    else if(getenv('REMOTE_ADDR'))
        $ipaddress = getenv('REMOTE_ADDR');
    else
        $ipaddress = 'UNKNOWN';
    return $ipaddress;
   }





  //GetCategories section 
  public function getCategoriesBySection($section = '') 
  {
    $returnData = array();
    if(!empty($section))
    {
        $PortalLink = (isset($_SESSION["webTvplayer"]["portallink"]))?$_SESSION["webTvplayer"]["portallink"]:"";
        $username = (isset($_SESSION["webTvplayer"]["username"]))?$_SESSION["webTvplayer"]["username"]:"";
        $password = (isset($_SESSION["webTvplayer"]["password"]))?$_SESSION["webTvplayer"]["password"]:"";
        $bar = "/";
        if(substr($PortalLink, -1) == "/")
        {
          $bar =  "";
        }
        $PortalLink = $PortalLink.$bar;
        $FinalLink = "";
        if($section == "live")
        {
          $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_live_categories";
        }
        if($section == "movies")
        {
          $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_vod_categories";
        }
        if($section == "series")
        {
          $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_series_categories";
        }
        if($section == "catchup")
        {
          $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_live_streams";
        }
        if($section == "radio")
        {
          $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_live_streams";
        }
        if($FinalLink != "")
        {
            $returnData = $this->CallApiRequest($FinalLink);
        }
    }
    return $returnData;
  }


  //GetCategories section 
  public function getMoviesByCateGoryID($categoryid = '') 
  {
    $returnData = array();
    if(!empty($categoryid))
    {
        $PortalLink = (isset($_SESSION["webTvplayer"]["portallink"]))?$_SESSION["webTvplayer"]["portallink"]:"";
        $username = (isset($_SESSION["webTvplayer"]["username"]))?$_SESSION["webTvplayer"]["username"]:"";
        $password = (isset($_SESSION["webTvplayer"]["password"]))?$_SESSION["webTvplayer"]["password"]:"";
        $bar = "/";
        if(substr($PortalLink, -1) == "/")
        {
          $bar =  "";
        }
        $PortalLink = $PortalLink.$bar;
        $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_vod_streams&category_id=".$categoryid;
        if($FinalLink != "")
        {
            $returnData = $this->CallApiRequest($FinalLink);
        }
    }
    return $returnData;
  }
  //Getstreaminfo movies section 
  public function getMoviesInfo($categoryid = '',$streamid = '') 
  {
    $returnData = array();
    if(!empty($categoryid) && !empty($streamid))
    {
        $PortalLink = (isset($_SESSION["webTvplayer"]["portallink"]))?$_SESSION["webTvplayer"]["portallink"]:"";
        $username = (isset($_SESSION["webTvplayer"]["username"]))?$_SESSION["webTvplayer"]["username"]:"";
        $password = (isset($_SESSION["webTvplayer"]["password"]))?$_SESSION["webTvplayer"]["password"]:"";
        $bar = "/";
        if(substr($PortalLink, -1) == "/")
        {
          $bar =  "";
        }
        $PortalLink = $PortalLink.$bar;
        $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_vod_info&vod_id=".$streamid;
        if($FinalLink != "")
        {
            $returnData = $this->CallApiRequest($FinalLink);
        }
    }
    return $returnData;
  }
  //Getstreaminfo movies section 
  public function getSeriesInfo($categoryid = '',$streamid = '') 
  {
    $returnData = array();
    if(!empty($categoryid) && !empty($streamid))
    {
        $PortalLink = (isset($_SESSION["webTvplayer"]["portallink"]))?$_SESSION["webTvplayer"]["portallink"]:"";
        $username = (isset($_SESSION["webTvplayer"]["username"]))?$_SESSION["webTvplayer"]["username"]:"";
        $password = (isset($_SESSION["webTvplayer"]["password"]))?$_SESSION["webTvplayer"]["password"]:"";
        $bar = "/";
        if(substr($PortalLink, -1) == "/")
        {
          $bar =  "";
        }
        $PortalLink = $PortalLink.$bar;
        $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_series_info&series_id=".$streamid;
        if($FinalLink != "")
        {
            $returnData = $this->CallApiRequest($FinalLink);
        }
    }
    return $returnData;
  }
  //Getstreaminfo live section 
  public function getliveStream($categoryid = '') 
  {
    $returnData = array();
    if(!empty($categoryid))
    {
        $PortalLink = (isset($_SESSION["webTvplayer"]["portallink"]))?$_SESSION["webTvplayer"]["portallink"]:"";
        $username = (isset($_SESSION["webTvplayer"]["username"]))?$_SESSION["webTvplayer"]["username"]:"";
        $password = (isset($_SESSION["webTvplayer"]["password"]))?$_SESSION["webTvplayer"]["password"]:"";
        $bar = "/";
        if(substr($PortalLink, -1) == "/")
        {
          $bar =  "";
        }
        $PortalLink = $PortalLink.$bar;
        $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_live_streams&category_id=".$categoryid;

        if($FinalLink != "")
        {
            $returnData = $this->CallApiRequest($FinalLink);            
        }
    }
    return $returnData;
  }
  //Getstreaminfo catchup view section 
  public function getcatchupStream($categoryid = '') 
  {
    $returnData = array();
    if(!empty($categoryid))
    {
        $PortalLink = (isset($_SESSION["webTvplayer"]["portallink"]))?$_SESSION["webTvplayer"]["portallink"]:"";
        $username = (isset($_SESSION["webTvplayer"]["username"]))?$_SESSION["webTvplayer"]["username"]:"";
        $password = (isset($_SESSION["webTvplayer"]["password"]))?$_SESSION["webTvplayer"]["password"]:"";
        $bar = "/";
        if(substr($PortalLink, -1) == "/")
        {
          $bar =  "";
        }
        $PortalLink = $PortalLink.$bar;
        $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_live_streams&category_id=".$categoryid;

        if($FinalLink != "")
        {
            $returnData = $this->CallApiRequest($FinalLink);            
        }
    }
    return $returnData;
  }
  //Get EPG info movies section 
  public function getEpgDataByCateGoryID($StreamId = '') 
  {
    $returnData = array();
    if(!empty($StreamId))
    {
        $PortalLink = (isset($_SESSION["webTvplayer"]["portallink"]))?$_SESSION["webTvplayer"]["portallink"]:"";
        $username = (isset($_SESSION["webTvplayer"]["username"]))?$_SESSION["webTvplayer"]["username"]:"";
        $password = (isset($_SESSION["webTvplayer"]["password"]))?$_SESSION["webTvplayer"]["password"]:"";
        $bar = "/";
        if(substr($PortalLink, -1) == "/")
        {
          $bar =  "";
        }
        $PortalLink = $PortalLink.$bar;
        $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_simple_data_table&stream_id=".$StreamId;

        if($FinalLink != "")
        {
            $returnData = $this->CallApiRequest($FinalLink);
        }
    }
    return $returnData;
  }


  //GetCategories section 
  public function getSeriesByCateGoryID($categoryid = '') 
  {
    $returnData = array();
    if(!empty($categoryid))
    {
        $PortalLink = (isset($_SESSION["webTvplayer"]["portallink"]))?$_SESSION["webTvplayer"]["portallink"]:"";
        $username = (isset($_SESSION["webTvplayer"]["username"]))?$_SESSION["webTvplayer"]["username"]:"";
        $password = (isset($_SESSION["webTvplayer"]["password"]))?$_SESSION["webTvplayer"]["password"]:"";
        $bar = "/";
        if(substr($PortalLink, -1) == "/")
        {
          $bar =  "";
        }
        $PortalLink = $PortalLink.$bar;
        $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_series&category_id=".$categoryid;
        if($FinalLink != "")
        {
            $returnData = $this->CallApiRequest($FinalLink);
        }
    }
    return $returnData;
  }

  //Check blocked ip address for admin panel
  public function checkblockedip($conn = '') {
      $returnData = "1";  
      if(!empty($conn))
      {
        $currenttime = time();
        $clientIPaddress = $this->client_ipaddress();
        $QueryData = array("request"=> "Get","table"=> "webtvtheme_blockedips", "data" => array("ipaddress" => $clientIPaddress)); 
         $ExecuteQuery =  $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
         if(!empty($ExecuteQuery))
         {
            $returnData = "0";  
             $blockedon = (isset($ExecuteQuery[0]["created_on"]) && $ExecuteQuery[0]["created_on"] != "")?$ExecuteQuery[0]["created_on"]:"";
              $lastblockedtime = strtotime($blockedon);
              $hoursdiff = ceil(round($currenttime - $lastblockedtime)/3600); 
              if($hoursdiff >= 24)
              {
                $deleteQueryData = array("request"=> "Delete","table"=> "webtvtheme_loginattempts", "data" => array("ipaddress" => $clientIPaddress));
                $this->adminfunconn->webtvtheme_ExecuteQuery($deleteQueryData,$conn);
                $deleteQueryData = array("request"=> "Delete","table"=> "webtvtheme_blockedips", "data" => array("ipaddress" => $clientIPaddress));
                $this->adminfunconn->webtvtheme_ExecuteQuery($deleteQueryData,$conn);
                $returnData = "1";  
              }
         }
      }
      return $returnData;
    }
  //Check blocked ip address for admin panel
  public function getblockedipsaddresslist($conn = '') {
      $returnData = array();  
      if(!empty($conn))
      {
        $currenttime = time();
        $clientIPaddress = $this->client_ipaddress();
        $QueryData = array("request"=> "Get","table"=> "webtvtheme_blockedips", "data" => array(),"extra" => array("ORDER BY id DESC")); 
         $returnData =  $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
      }
      return $returnData;
    }


  //Check blocked ip address for admin panel
  public function DeleteBlockedIdsWithIdsArray($ExplodedIDS = array(),$conn = '') {
      $returnData = 0;  
      if(!empty($conn))
      {
        if(!empty($ExplodedIDS))
        {
            $TotalsIDS = count($ExplodedIDS);
            foreach($ExplodedIDS as $IDis)
            {
                $QueryData = array("request"=> "Get","table"=> "webtvtheme_blockedips", "data" => array("id" => $IDis)); 
                $RecordData =  $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
                if(isset($RecordData[0]["ipaddress"]) && $RecordData[0]["ipaddress"] != "")
                { 
                    $clientIPaddress =  $RecordData[0]["ipaddress"];
                    $deleteQueryData = array("request"=> "Delete","table"=> "webtvtheme_loginattempts", "data" => array("ipaddress" => $clientIPaddress));
                    $this->adminfunconn->webtvtheme_ExecuteQuery($deleteQueryData,$conn);
                    $deleteQueryData = array("request"=> "Delete","table"=> "webtvtheme_blockedips", "data" => array("ipaddress" => $clientIPaddress));
                    $this->adminfunconn->webtvtheme_ExecuteQuery($deleteQueryData,$conn);
                }
            }
            $returnData = 1;  
        }
      }
      return $returnData;
    }


  //Check blocked ip address for admin panel
  public function addActivityOnload($conn = '') {
      $returnData = 0;  
      if(!empty($conn))
      {
        $currenttime = time();
        $clientIPaddress = $this->client_ipaddress();
        $QueryData = array("request"=> "Get","table"=> "webtvtheme_activitylogs", "data" => array("ipaddress" => $clientIPaddress)); 
        $RecordData =  $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
        if(!empty($RecordData))
        {
            $ID = (isset($RecordData[0]["id"]) && $RecordData[0]["id"] != "")?$RecordData[0]["id"]:"";
            if($ID != "")
            {
                $QueryData = array("request"=> "Update","table"=> "webtvtheme_activitylogs", "data" => array("id" => $ID),"updatedata" => array("lastactive" => $currenttime));
                $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
            }
        }
        else
        {
          $QueryData = array("request"=> "Insert","table"=> "webtvtheme_activitylogs", "data" => array("ipaddress" => $clientIPaddress,"lastactive" => $currenttime));
          $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
        }
      }
      return $returnData;
    }



  //Check blocked ip address for admin panel
  public function getloggeduserslist($conn = '',$limit = "",$offset = "",$user = "",$portal ="",$status = "") {
      $returnData = array();  
      if(!empty($conn))
      {
        $string=array();
        if($user != "")
        {
            $string["username"] = $user;
        }
        if($portal != "")
        {
          $string["portallink"] = $portal;
        }
       if($status != "")
       {
        $string["status"] = $status;
       }
       
        $currenttime = time();
        $clientIPaddress = $this->client_ipaddress();
        $QueryData = array("request"=> "Count","table"=> "webtvtheme_userdetails", "data" => $string,"extra" => array()); 
        $TotalRecords =  $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
        $QueryData = array("request"=> "Get","table"=> "webtvtheme_userdetails", "data" => $string,"extra" => array("ORDER BY id DESC" , "LIMIT $offset,$limit")); 
        
        $returnData["total"] =  $TotalRecords;
        $returnData["data"] =  $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
      }
      return $returnData;
    }
 public function getloggedusersfulllist($conn = '',$limit = "",$offset = "",$uid) {

      $returnData = array();  
      if(!empty($conn))
      {
        $currenttime = time();
        $clientIPaddress = $this->client_ipaddress();
        $QueryData = array("request"=> "Count","table"=> "webtvtheme_log", "data" => array("user_id" => $uid),"extra" => array()); 
        $TotalRecords =  $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
        $QueryData = array("request"=> "Get","table"=> "webtvtheme_log", "data" => array("user_id" => $uid),"extra" => array("ORDER BY id DESC" , "LIMIT $offset,$limit"));
        $returnData["total"] =  $TotalRecords;
        $returnData["data"] =  $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
      }
    
      return $returnData;
    }

  //Check Current User Statys
  public function checkCurrentUserStatus($conn = '',$limit = "",$offset = "") {
      $returnData = "Active";  
      if(!empty($conn))
      {
        $username = $_SESSION["webTvplayer"]["username"];
        $Pass = $_SESSION["webTvplayer"]["password"];
        $EncPassword = $this->adminfunconn->webtvtheme_encrypt($Pass);
        $Fportallink = $_SESSION["webTvplayer"]["portallink"];
        $bar = "/";
        if(substr($Fportallink, -1) == "/")
        {
          $bar =  "";
        }
        $Fportallink = $Fportallink.$bar;
        $QueryData = array("request"=> "Get","table"=> "webtvtheme_userdetails", "data" => array("username" => $username,"password" => $EncPassword,"portallink" => $Fportallink));  
        $UserData = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
        if(!empty($UserData))
        {
          $returnData = $UserData[0]["status"];
        }
      }
      return $returnData;
    }



   public function getWorkingTestlineByListID($conn = '',$ListID = "") {
      $returnData = array("result" => "error", "message" => "Invalid Details");   
      if(!empty($conn))
      {
        $QueryData = array("request"=> "Get","table"=> "webtvtheme_testlinedetails", "data" => array("id" => $ListID)); 
        $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
        if(!empty($ExecuteQuery))
        {
            $portallink = $ExecuteQuery[0]["portallink"];
            $bar = "/";
            if(substr($portallink, -1) == "/")
            {
              $bar =  "";
            }
            $portallink = $portallink.$bar;
            $username = $ExecuteQuery[0]["username"];
            $password = $this->adminfunconn->webtvtheme_decrypt($ExecuteQuery[0]["password"]);
            $CallApiRequest = $portallink."player_api.php?username=".$username."&password=".$password;   
            $APIresponse = $this->CallApiRequest($CallApiRequest);
            $Result = $APIresponse;
            if($Result['result'] == "success")
            {
              if(isset($Result['data']->user_info->auth))
              {
                  if($Result['data']->user_info->auth != 0)
                  {
                      if($Result['data']->user_info->status == 'Active')
                      {
                        $returnData = array("result" => "success", "message" => "Valid Details","insertid" => base64_encode($ExecuteQuery[0]["id"]),"portallink" => $portallink);
                      }
                  }
              }
            }
        }

      }
      return $returnData;
    } 

     public function GetBannersListByCateGoryData($conn = '',$ListID = "",$section = "") {
        $returnData = array();   
        if(!empty($conn))
        {
          $QueryData = array("request"=> "Get","table"=> "webtvtheme_testlinedetails", "data" => array("id" => $ListID)); 
          $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
          if(!empty($ExecuteQuery))
          {
              $FinalCateGoryWithCOunt = array();
              $portallink = $ExecuteQuery[0]["portallink"];
              $bar = "/";
              if(substr($portallink, -1) == "/")
              {
                $bar =  "";
              }
              $PortalLink = $portallink.$bar;
              $FullQuery = "SELECT category,  COUNT(category) as totalresult FROM webtvtheme_banners WHERE portalurl = '".mysqli_real_escape_string($conn,$PortalLink)."' AND type = '".mysqli_real_escape_string($conn,$section)."' GROUP BY category";
              $QueryData = array("request"=> "FullCustomQuery","query"=> $FullQuery);
              $result = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
              if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                      $returnData[$row['category']] = $row['totalresult'];
                  }
              }
          }

        }
        return $returnData;
     }

     public function getCategoriesBySectionAndListID($conn = '',$ListID = "",$section = "") {
      $returnData = array("result" => "error", "message" => "Invalid Details");   
      if(!empty($conn))
      {
        $QueryData = array("request"=> "Get","table"=> "webtvtheme_testlinedetails", "data" => array("id" => $ListID)); 
        $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
        if(!empty($ExecuteQuery))
        {
            $username = $ExecuteQuery[0]["username"];
            $password = $this->adminfunconn->webtvtheme_decrypt($ExecuteQuery[0]["password"]);
            $portallink = $ExecuteQuery[0]["portallink"];
            $bar = "/";
            if(substr($portallink, -1) == "/")
            {
              $bar =  "";
            }
            $PortalLink = $portallink.$bar;
            $FinalLink = "";
            if($section == "live")
            {
              $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_live_categories";
            }
            if($section == "movies")
            {
              $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_vod_categories";
            }
            if($section == "series")
            {
              $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_series_categories";
            }
            if($section == "catchup")
            {
              $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_live_streams";
            }
            if($section == "radio")
            {
              $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_live_streams";
            }
            $returnData = $this->CallApiRequest($FinalLink);
        }

      }
      return $returnData;
    } 


   public function getStreamsByCateIDSectionAndListID($conn = '',$ListID = "",$section = "",$categoryid = "") {
      $returnData = array("result" => "error", "message" => "Invalid Details");   
      if(!empty($conn))
      {
        $QueryData = array("request"=> "Get","table"=> "webtvtheme_testlinedetails", "data" => array("id" => $ListID)); 
        $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
        if(!empty($ExecuteQuery))
        {
            $username = $ExecuteQuery[0]["username"];
            $password = $this->adminfunconn->webtvtheme_decrypt($ExecuteQuery[0]["password"]);
            $portallink = $ExecuteQuery[0]["portallink"];
            $bar = "/";
            if(substr($portallink, -1) == "/")
            {
              $bar =  "";
            }
            $PortalLink = $portallink.$bar;
            $FinalLink = "";
            if($section == "live")
            {
              $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_live_streams&category_id=".$categoryid;
            }
            if($section == "movies")
            {
              $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_vod_streams&category_id=".$categoryid;
            }
            if($section == "series")
            {
              $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_series&category_id=".$categoryid;
            }
            if($section == "catchup")
            {
              $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_live_streams&category_id=".$categoryid;
            }
            if($section == "radio")
            {
              $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_live_streams&category_id=".$categoryid;
            }
            $returnData = $this->CallApiRequest($FinalLink);
        }

      }
      return $returnData;
    } 


   public function GetSingleStreamDataByStreamIDListID($conn = '',$ListID = "",$section = "",$StreamID = "") {
      $returnData = array("result" => "error", "message" => "Invalid Details");   
      if(!empty($conn))
      {
        $QueryData = array("request"=> "Get","table"=> "webtvtheme_testlinedetails", "data" => array("id" => $ListID)); 
        $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
        if(!empty($ExecuteQuery))
        {
            $username = $ExecuteQuery[0]["username"];
            $password = $this->adminfunconn->webtvtheme_decrypt($ExecuteQuery[0]["password"]);
            $portallink = $ExecuteQuery[0]["portallink"];
            $bar = "/";
            if(substr($portallink, -1) == "/")
            {
              $bar =  "";
            }
            $PortalLink = $portallink.$bar;
            $FinalLink = "";
            if($section == "movies")
            {
              $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_vod_info&vod_id=".$StreamID;
            }
            if($section == "series")
            {
              $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_series_info&series_id=".$StreamID;
            }
            $returnData = $this->CallApiRequest($FinalLink);
        }

      }
      return $returnData;
    } 


    public function BannerSliderFromExternalAPI($name = '',$type = "") 
    {
      $name = str_replace(" " , "%20", $name);
      $ApiLinkIs =  "https://api.themoviedb.org/3/search/tv?api_key=f584f73e8848d9ace559deee1e5a849f&query=$name";
      if($type == "movies")
      {
        $ApiLinkIs = "https://api.themoviedb.org/3/search/movie?api_key=f584f73e8848d9ace559deee1e5a849f&query=$name";
      }
      $GetSliderFromTMBD = $this->CallApiRequest($ApiLinkIs);
      if($GetSliderFromTMBD['result'] == "success")
      {
        if(!empty($GetSliderFromTMBD['data']->results))
        {
          if($GetSliderFromTMBD['data']->results[0]->backdrop_path != "")
          {
            return "https://image.tmdb.org/t/p/w1280".$GetSliderFromTMBD['data']->results[0]->backdrop_path;
          }
          else
          {
            return "";
          }
        }
      }
    }

    public function GetBlockedDataByPortalLInk($conn = '',$PortalLInk = "") 
    {
      $returndata = array();
      if(!empty($conn))
      {
          if(substr($PortalLInk, -1) == "/")
          {
            $bar =  "";
          }
          $portallink = $PortalLInk.$bar;
          $QueryData = array("request"=> "Get","table"=> "webtvtheme_blocked_section", "data" => array("portallink" => $portallink));
          $GetData = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
          if(!empty($GetData))
          {
             foreach($GetData as $Sval)
             {
                $returndata[$Sval["section"]] = $Sval["section"];
             }
          }
      }
      return $returndata;
    }  


 public function getBlockedCategoriesIts($conn = '',$ListID = "",$section = "") {
      $returnData = array();   
      if(!empty($conn))
      {
        $QueryData = array("request"=> "Get","table"=> "webtvtheme_testlinedetails", "data" => array("id" => $ListID)); 
        $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
        if(!empty($ExecuteQuery))
        {
            $username = $ExecuteQuery[0]["username"];
            $password = $this->adminfunconn->webtvtheme_decrypt($ExecuteQuery[0]["password"]);
            $portallink = $ExecuteQuery[0]["portallink"];
            $bar = "/";
            if(substr($portallink, -1) == "/")
            {
              $bar =  "";
            }
            $PortalLink = $portallink.$bar;
            $QueryData = array("request"=> "Get","table"=> "webtvtheme_blocked_categories", "data" => array("type" => $section,"portallink" => $PortalLink));
            $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
            if(!empty($ExecuteQuery))
            {
              foreach($ExecuteQuery as $getkey)
              {
                  $returnData[] = $getkey["category_id"];
              } 
            }
        }

      }
      return $returnData;
    } 

 public function getBlockedSeriesEpisode($conn = '',$ListID = "",$StreamIDis = "",$categoryIs = "",$episodesid = "") {
      $returnData = array();   
      if(!empty($conn))
      {
        $QueryData = array("request"=> "Get","table"=> "webtvtheme_testlinedetails", "data" => array("id" => $ListID)); 
        $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
        if(!empty($ExecuteQuery))
        {
            $username = $ExecuteQuery[0]["username"];
            $password = $this->adminfunconn->webtvtheme_decrypt($ExecuteQuery[0]["password"]);
            $portallink = $ExecuteQuery[0]["portallink"];
            $bar = "/";
            if(substr($portallink, -1) == "/")
            {
              $bar =  "";
            }
            $PortalLink = $portallink.$bar;
            $QueryData = array("request"=> "Get","table"=> "webtvtheme_blocked_Seriesstreams", "data" => array("streams_id" => $StreamIDis,"category_id" => $categoryIs,"episode_id" => $episodesid,"portallink" => $PortalLink));
            $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
            if(!empty($ExecuteQuery))
            {
              foreach($ExecuteQuery as $getkey)
              {
                  $returnData[] = $getkey["episode_id"];
              } 
            }
        }

      }
      return $returnData;
    } 

   public function GetStreamsByCategoryAndSecForBlock($conn = '',$ListID = "",$section = "",$category = "") {
      $returnData = array();   
      if(!empty($conn))
      {
        $QueryData = array("request"=> "Get","table"=> "webtvtheme_testlinedetails", "data" => array("id" => $ListID)); 
        $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
        if(!empty($ExecuteQuery))
        {
            $username = $ExecuteQuery[0]["username"];
            $password = $this->adminfunconn->webtvtheme_decrypt($ExecuteQuery[0]["password"]);
            $portallink = $ExecuteQuery[0]["portallink"];
            $bar = "/";
            if(substr($portallink, -1) == "/")
            {
              $bar =  "";
            }
            $PortalLink = $portallink.$bar;
            $FinalLink = $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_live_streams&category_id=".$category;;
            if($section == "movies")
            {
              $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_vod_streams&category_id=".$category;
            }
            if($section == "series")
            {
              $FinalLink = $PortalLink."player_api.php?username=".$username."&password=".$password."&action=get_series&category_id=".$category;
            }
            $returnData = $this->CallApiRequest($FinalLink);
        }

      }
      return $returnData;
    } 



    public function getBlockedStreamsIts($conn = '',$ListID = "",$section = "",$cate = "") {
      $returnData = array();   
      if(!empty($conn))
      {
        $QueryData = array("request"=> "Get","table"=> "webtvtheme_testlinedetails", "data" => array("id" => $ListID)); 
        $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
        if(!empty($ExecuteQuery))
        {
            $username = $ExecuteQuery[0]["username"];
            $password = $this->adminfunconn->webtvtheme_decrypt($ExecuteQuery[0]["password"]);
            $portallink = $ExecuteQuery[0]["portallink"];
            $bar = "/";
            if(substr($portallink, -1) == "/")
            {
              $bar =  "";
            }
            $PortalLink = $portallink.$bar;
            $QueryData = array("request"=> "Get","table"=> "webtvtheme_blocked_streams", "data" => array("category_id" => $cate,"section" => $section,"portallink" => $PortalLink));
            $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
            if(!empty($ExecuteQuery))
            {
              foreach($ExecuteQuery as $getkey)
              {
                  $returnData[] = $getkey["streams_id"];
              } 
            }
        }

      }
      return $returnData;
    }

    public function getActivePortal($conn = "",$portallink = "") 
    {

      $returnData = "";  
      if(!empty($conn))
      {
          $QueryData = array("request"=> "Get","table"=> "webtvtheme_testlinedetails", "data" => array("portallink" => $portallink)); 
          $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
         
          if(!empty($ExecuteQuery))
          {
            $username = $ExecuteQuery[0]["username"];
            $password =  $this->adminfunconn->webtvtheme_decrypt($ExecuteQuery[0]["password"]);
            $ApiRequestCall = $portallink."player_api.php?username=".$username."&password=".$password;
           
            $APIresponse = $this->CallApiRequest($ApiRequestCall);
            $Result = $APIresponse;

            if($Result['result'] == "success")
            {
              if(isset($Result['data']->user_info->auth))
              {
                  if($Result['data']->user_info->auth != 0)
                  {
                      if($Result['data']->user_info->status == 'Active')
                      {
                        $returnData = $ExecuteQuery[0]["id"];
                      }
                  }
              }
            }        
            
          }
      }
      return $returnData;

    }

    public function GetThemeActivationCode($conn = "",$theme = "") 
    {

      $returnData = "";  
      if(!empty($conn))
      {
         $QueryData = array("request"=> "Get","table"=> "webtvtheme_theme_activation", "data" => array("theme" => $theme));
          $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
          if(!empty($ExecuteQuery))
          {
            $returnData = (isset($ExecuteQuery[0]["code"]) && !empty($ExecuteQuery[0]["code"]))?$ExecuteQuery[0]["code"]:"";
          }
      }
      return $returnData;

    }

    public function CheckThemeActivationCode($conn = "",$ThemeCodeIS = "",$theme = "",$LicenseIS = "") 
    {

      $returnData = "Invalid"; 
      $FinalLicense = ""; 
      if($LicenseIS == "")
      {
          if(!empty($conn))
          {
              $ConfigDetails = $this->getconfigurationoption($conn,"1");
              $FinalLicense = (isset($ConfigDetails["license"]) && $ConfigDetails["license"] != "")?$ConfigDetails["license"]:"";
          }
      }
      else
      {
          $FinalLicense = $LicenseIS;
      }

      $salt = '#|_0^3%*&';
      $ActualCodeForCompare = md5(sha1($theme . $FinalLicense. $salt));
      if($ThemeCodeIS == $ActualCodeForCompare)
      {
          $returnData = "Active";
      }
      return $returnData;
    }


    public function GenerateThemeActivationCodesForDefault($conn = "",$license = "") 
    {
      $returnData = ""; 
      $theme = "default";
      $CreateAndAdd = "";
      if(!empty($conn))
      {
          $QueryData = array("request"=> "Get","table"=> "webtvtheme_theme_activation", "data" => array("theme" => $theme));
          $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
          if(!empty($ExecuteQuery))
          {
              $code = $ExecuteQuery[0]["code"];
              $checkExisting = $this->CheckThemeActivationCode($conn,$code,$theme,$license);
              if($checkExisting == "Active")
              {
                  $CreateAndAdd = "1";
              }
          }
          if($CreateAndAdd == "")
          {
            $QueryData = array("request"=> "Get","table"=> "webtvtheme_theme_activation", "data" => array("theme" => $theme));
            $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
            if(!empty($ExecuteQuery))
            {
                $deleteQueryData = array("request"=> "Delete","table"=> "webtvtheme_theme_activation", "data" => array("theme" => $theme));
                $this->adminfunconn->webtvtheme_ExecuteQuery($deleteQueryData,$conn);
            }
            $salt = '#|_0^3%*&';
            $ActualCodeForCompare = md5(sha1($theme . $license. $salt));
            $QueryData = array("request"=> "Insert","table"=> "webtvtheme_theme_activation", "data" => array("theme" => $theme,"code" => $ActualCodeForCompare));
            $QueryExicute = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
          }
      }
      return $returnData;
    }

    public function GetCastDataByTypeCount($conn = "",$Type = "") 
    {      
      $returnData = "0"; 
      if(!empty($conn))
      {
          $QueryData = array("request"=> "Count","table"=> "webtvtheme_cast_container", "data" => array("type" => $Type));
          $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
          if(!empty($ExecuteQuery))
          {
            $returnData = $ExecuteQuery;
          }
      }
      return $returnData;
    }

    public function GetCastDataByTypeCountSearch($conn = "",$Type = "",$filtertext = "") 
    {   
      $returnData = "0"; 
      if(!empty($conn))
      {
          $QueryData = array("request"=> "FullCustomQuery","query"=> "SELECT * FROM `webtvtheme_cast_container` WHERE `cast_name` LIKE '%".$filtertext."%' AND `type` LIKE '".$Type."'");
          $result = $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
          if ($result->num_rows > 0) {
            $returnData = $result->num_rows;
          }
      }
      return $returnData;
    }


    public function GetCastDataByTypeSearch($conn = "",$Type = "",$filtertext = "") 
    {   
      $returnData = array(); 
      if(!empty($conn))
      {
          $QueryData = array("request"=> "FullCustomQuery","query"=> "SELECT * FROM `webtvtheme_cast_container` WHERE `cast_name` LIKE '%".$filtertext."%' AND `type` LIKE '".$Type."' ORDER BY popularity DESC");
          $result = $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
          if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                      $returnData[] = $row;
                  }
          }
      }
      return $returnData;
    }

    public function GetCastDataByType($conn = "",$Type = "",$offset = "0",$Limit = "40",$Orderby = "ORDER BY cast_name ASC") 
    {      
      $returnData = array(); 
      if(!empty($conn))
      {
          $QueryData = array("request"=> "Get","table"=> "webtvtheme_cast_container", "data" => array("type" => $Type),"extra" => array($Orderby,"LIMIT $offset,$Limit"));
          $ExecuteQuery = $this->adminfunconn->webtvtheme_ExecuteQuery($QueryData,$conn);
          if(!empty($ExecuteQuery))
          {
            $returnData = $ExecuteQuery;
          }
      }
      return $returnData;
    }
}


